(define/contract (permute-unique nums)
  (-> (listof exact-integer?) (listof (listof exact-integer?)))
  (define (helper nums visited path res)
    (if (= (length path) (length nums))
        (cons (reverse path) res)
        (let loop ([i 0] [res res] [prev #f])
          (if (>= i (length nums))
              res
              (let ([num (list-ref nums i)])
                (if (or (list-ref visited i)
                         (and (not (false? prev)) (= prev num)))
                    (loop (add1 i) res prev)
                    (loop (add1 i)
                          (helper nums
                                 (list-set visited i #t)
                                 (cons num path)
                                 res)
                          num)))))))
  (let ([sorted-nums (sort nums <)])
    (helper sorted-nums (make-list (length nums) #f) '() '())))